"""init

Revision ID: c2b4247b094f
Revises: 
Create Date: 2023-01-23 12:29:20.187105

"""  # noqa: W291
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "c2b4247b094f"
down_revision = None
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from hitfactorpy_sqlalchemy.orm.models import (
        SAEnumMatchLevel,
        SAEnumClassification,
        SAEnumDivision,
        SAEnumPowerFactor,
        SAEnumScoring,
    )

    op.create_table(
        "match_report",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("uuid", postgresql.UUID(as_uuid=True), server_default=sa.text("gen_random_uuid()"), nullable=False),
        sa.Column("name", sa.Unicode(length=255), nullable=False),
        sa.Column("date", sa.Date(), nullable=True),
        sa.Column("match_level", SAEnumMatchLevel, nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_match_report_uuid"), "match_report", ["uuid"], unique=True)
    op.create_table(
        "match_report_competitor",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("uuid", postgresql.UUID(as_uuid=True), server_default=sa.text("gen_random_uuid()"), nullable=False),
        sa.Column("match_id", sa.Integer(), nullable=False),
        sa.Column("member_number", sa.Unicode(length=64), nullable=True),
        sa.Column("first_name", sa.Unicode(length=64), nullable=True),
        sa.Column("last_name", sa.Unicode(length=64), nullable=True),
        sa.Column("division", SAEnumDivision, nullable=True),
        sa.Column("classification", SAEnumClassification, nullable=True),
        sa.Column("power_factor", SAEnumPowerFactor, nullable=True),
        sa.Column("dq", sa.Boolean(), nullable=False),
        sa.Column("reentry", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["match_id"], ["match_report.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_match_report_competitor_uuid"), "match_report_competitor", ["uuid"], unique=True)
    op.create_table(
        "match_report_stage",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("uuid", postgresql.UUID(as_uuid=True), server_default=sa.text("gen_random_uuid()"), nullable=False),
        sa.Column("match_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Unicode(length=255), nullable=True),
        sa.Column("min_rounds", sa.Integer(), nullable=False),
        sa.Column("max_points", sa.Integer(), nullable=False),
        sa.Column("classifier", sa.Boolean(), nullable=False),
        sa.Column("classifier_number", sa.Unicode(length=64), nullable=True),
        sa.Column("scoring_type", SAEnumScoring, nullable=False),
        sa.ForeignKeyConstraint(["match_id"], ["match_report.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_match_report_stage_uuid"), "match_report_stage", ["uuid"], unique=True)
    op.create_table(
        "match_report_stage_score",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("uuid", postgresql.UUID(as_uuid=True), server_default=sa.text("gen_random_uuid()"), nullable=False),
        sa.Column("match_id", sa.Integer(), nullable=False),
        sa.Column("competitor_id", sa.Integer(), nullable=False),
        sa.Column("stage_id", sa.Integer(), nullable=False),
        sa.Column("a", sa.Integer(), nullable=False),
        sa.Column("b", sa.Integer(), nullable=False),
        sa.Column("c", sa.Integer(), nullable=False),
        sa.Column("d", sa.Integer(), nullable=False),
        sa.Column("m", sa.Integer(), nullable=False),
        sa.Column("npm", sa.Integer(), nullable=False),
        sa.Column("ns", sa.Integer(), nullable=False),
        sa.Column("procedural", sa.Integer(), nullable=False),
        sa.Column("late_shot", sa.Integer(), nullable=False),
        sa.Column("extra_shot", sa.Integer(), nullable=False),
        sa.Column("extra_hit", sa.Integer(), nullable=False),
        sa.Column("other_penalty", sa.Integer(), nullable=False),
        sa.Column("t1", sa.Float(), nullable=False),
        sa.Column("t2", sa.Float(), nullable=False),
        sa.Column("t3", sa.Float(), nullable=False),
        sa.Column("t4", sa.Float(), nullable=False),
        sa.Column("t5", sa.Float(), nullable=False),
        sa.Column("time", sa.Float(), nullable=False),
        sa.Column("dq", sa.Boolean(), nullable=False),
        sa.Column("dnf", sa.Boolean(), nullable=False),
        sa.ForeignKeyConstraint(["competitor_id"], ["match_report_competitor.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["match_id"], ["match_report.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["stage_id"], ["match_report_stage.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_match_report_stage_score_uuid"), "match_report_stage_score", ["uuid"], unique=True)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    from hitfactorpy_sqlalchemy.orm.models import (
        SAEnumMatchLevel,
        SAEnumClassification,
        SAEnumDivision,
        SAEnumPowerFactor,
        SAEnumScoring,
    )

    op.drop_index(op.f("ix_match_report_stage_score_uuid"), table_name="match_report_stage_score")
    op.drop_table("match_report_stage_score")
    op.drop_index(op.f("ix_match_report_stage_uuid"), table_name="match_report_stage")
    op.drop_table("match_report_stage")
    op.drop_index(op.f("ix_match_report_competitor_uuid"), table_name="match_report_competitor")
    op.drop_table("match_report_competitor")
    op.drop_index(op.f("ix_match_report_uuid"), table_name="match_report")
    op.drop_table("match_report")

    SAEnumMatchLevel.drop(op.get_bind())
    SAEnumClassification.drop(op.get_bind())
    SAEnumDivision.drop(op.get_bind())
    SAEnumPowerFactor.drop(op.get_bind())
    SAEnumScoring.drop(op.get_bind())
    # ### end Alembic commands ###
